<?php
	use Cake\Utility\Inflector;
?>

<h1><?php echo $subject; ?>管理</h1>

<?php if ($this->request->action == 'confirm') : // 登録、修正確認画面 ?>
	<h2><?php echo $subject; ?><?php echo (empty($formEntity->id) ? '登録' : '編集'); ?></h2>
	<h3>以下の内容で<?php echo $subject; ?>を更新します<br />よろしければ「完了」を、修正する場合は「戻る」をクリックしてください</h3>
<?php elseif ($this->request->action == 'deleteConfirm') : // 削除確認画面 ?>
	<h3>以下の<?php echo $subject; ?>を削除します<br />よろしければ「完了」を、削除しない場合は「戻る」をクリックしてください</h3>
<?php elseif ($this->request->action == 'show') : // 詳細画面 ?>
	<h2><?php echo $subject; ?>詳細</h2>
<?php endif; // 削除確認画面ここまで ?>

<table class="table table-bordered form">
	<?php echo $this->element('../Admin/' . Inflector::camelize($this->request->controller) . '/_form'); ?>
</table>

<?php if ($this->request->action == 'confirm') : // 登録、修正確認画面 ?>

	<?php
		echo $this->Form->create($formEntity, ['url' => ['controller' => Inflector::underscore($this->request->params['controller']), 'action' => 'add'], 'name' => 'add']);
		echo $this->Form->hidden('formToken', ['value' => $formToken]);
		echo $this->Form->end();
	?>
	<?php
		echo $this->Form->create($formEntity, ['url' => ['controller' => Inflector::underscore($this->request->params['controller']), 'action' => 'complete'], 'name' => 'complete']);
		echo $this->Form->hidden('formToken', ['value' => $formToken]);
		echo $this->Form->end();
	?>
	<div>
		<?php echo $this->Html->link('戻る', "javascript:jQuery('form[name=add]').submit();", array('class' => 'btn btn-warning')); ?>
		<?php echo $this->Html->link('完了', "javascript:jQuery('form[name=complete]').submit();", array('class' => 'btn btn-primary')); ?>
	</div>

<?php elseif ($this->request->action == 'deleteConfirm') : // 削除確認画面 ?>

	<?php
		echo $this->Form->create($formEntity, ['url' => ['controller' => Inflector::underscore($this->request->params['controller']), 'action' => 'deleteComplete'], 'name' => 'complete']);
		echo $this->Form->hidden('id');
		echo $this->Form->end();
	?>

	<div>
		<?php echo $this->Html->link('戻る', ($redirectUrl + ['back' => true]), ['class' => 'btn btn-warning']); ?>
		<?php echo $this->Html->link('完了', "javascript:jQuery('form[name=complete]').submit();", array('class' => 'btn btn-primary')); ?>
	</div>

<?php elseif ($this->request->action == 'show') : // 詳細画面 ?>

	<div>
		<?php echo $this->Html->link('戻る', ($redirectUrl + ['back' => true]), ['class' => 'btn btn-warning']); ?>
	</div>

<?php endif; // ここまで ?>
