<?php
namespace Cbase\Model\Validation;
use Cake\Validation\Validator;

class CbaseValidator extends Validator
{

    /**
     * contruct
     */
    public function __construct()
    {
        $this->provider('cbase', 'Cbase\Model\Validation\CbaseValidation');
        parent::__construct();
    }

    /**
     * 3fieldにわかれた電話番号入力のチェック
     * エラーは$fields[0]に出力
     */
    public function telThree($fields, $allowEmpty = true, $emptyMessage = null, $formatMessage = null)
    {
        if (count($fields) !== 3) return;
        if (empty($emptyMessage)) $emptyMessage = '入力してください';
        if (empty($formatMessage)) $formatMessage = '正しく入力してください';

        $this->notEmpty($fields[0], $emptyMessage, function($context) use ($fields, $allowEmpty) {
            if ($allowEmpty) {
                return !empty($context['data'][$fields[0]]) || !empty($context['data'][$fields[1]]) || !empty($context['data'][$fields[2]]);
            } else {
                return true;
            }
        });
        $this->add($fields[0], [
            'telThree' => [
                'rule' => ['telThree', [$fields[0], $fields[1], $fields[2]]],
                'provider' => 'cbase',
                'message' => $formatMessage,
            ],
            'telThreeEmpty' => [
                'rule' => ['telThreeEmpty', [$fields[0], $fields[1], $fields[2]]],
                'provider' => 'cbase',
                'message' => $emptyMessage,
            ],
        ]);

        return $this;
    }

    /**
     * 2fieldにわかれた郵便番号入力のチェック
     * エラーは$fields[0]に出力
     */
    public function zipCodeTwo($fields, $allowEmpty = true, $emptyMessage = null, $formatMessage = null)
    {
        if (count($fields) !== 2) return;
        if (empty($emptyMessage)) $emptyMessage = '入力してください';
        if (empty($formatMessage)) $formatMessage = '正しく入力してください';

        $this->notEmpty($fields[0], $emptyMessage, function($context) use ($fields, $allowEmpty) {
            if ($allowEmpty) {
                return !empty($context['data'][$fields[0]]) || !empty($context['data'][$fields[1]]);
            } else {
                return true;
            }
        });
        $this->add($fields[0], [
            'zipCodeTwo' => [
                'rule' => ['zipCodeTwo', [$fields[0], $fields[1]]],
                'provider' => 'cbase',
                'message' => $formatMessage,
            ],
            'zipCodeTwoEmpty' => [
                'rule' => ['zipCodeTwoEmpty', [$fields[0], $fields[1]]],
                'provider' => 'cbase',
                'message' => $emptyMessage,
            ],
        ]);

        return $this;
    }

}