<?php
namespace Cbase\View\Helper;

require_once(dirname(dirname(dirname(__DIR__))) . DS . 'vendor' . DS . 'Minifier.php');
use Cake\View\Helper;
use Cake\View\View;
use JShrink;

/**
 * Minify helper
 */
class MinifyHelper extends Helper
{

    /**
     * Default configuration.
     *
     * @var array
     */
    protected $_defaultConfig = [];

    /**
     * minify text
     */
    public function scriptBlock($str)
    {
        return $this->_text($str);
    }

    /**
     * minify start
     */
    public function scriptStart()
    {
        ob_start();
    }

    /**
     * minify end
     */
    public function scriptEnd()
    {
        $buffer = ob_get_clean();
        echo $this->_text($buffer);
    }

    /**
     * return minified text
     */
    private function _text($str)
    {
        return JShrink\Minifier::minify($str);
    }

}
