<?php
	// 以下の変数が必要
	// $fieldName
	// $tableName
	// $fileSel
	// $photoAreaSel
	// $size
	// $imageOptions

	// 送るimageOptions
	if (!empty($size[0])) {
		$imageOptions['width'] = $size[0];
	}
	if (!empty($size[1])) {
		$imageOptions['height'] = $size[1];
	}

	// ajax uploadするURL
	$enc = urlencode($fieldName);
	$uploadUrl = $this->Url->build("/cbase/uploader/upload/{$tableName}/{$enc}");
?>

<?php echo $this->Html->script('/cbase/js/jquery.inputFileResizer', ['block' => false]); ?>
<?php $this->Html->scriptStart(['block' => false]); ?>
	<?php $this->Minify->scriptStart(); ?>
		jQuery(function($){
			var fieldName = '<?php echo $fieldName; ?>';
			var fileSel = '<?php echo $fileSel; ?>';
			var photoAreaSel = '<?php echo $photoAreaSel; ?>';
			var uploadUrl = '<?php echo $uploadUrl; ?>';
			var imageOptions = JSON.stringify(<?php echo json_encode($imageOptions); ?>);
			var loader = '<?php echo $this->Html->image('/cbase/js/nupload/ajax-loader.gif'); ?>';

			// 写真が選択されたときにリサイズ
			$(document).on('change', fileSel, function(){
				// ファイルがない場合なにもしない
				if (this.files.length <= 0) {
					return;
				}
				var that = this;
				var fileObj = $(this);
				var photoAreaObj = $(this).prev(photoAreaSel);

				photoAreaObj.html(loader);
				// submitされないように全てのボタンはdisable
				$('.btn').attr('disabled', true);

				$(this).inputFileResizer({
					onStart: function(){
						//
					},
					onComplete: function(dataURL, dispImg, file){
						// ajaxでファイルのみPOST
						var fd = new FormData();
						var name = fieldName + '_file';
						if (!dataURL && !dispImg && !file) {
							// gifの場合リサイズ処理せず全てnullで返ってくる
							var files = that.files;
							$.each(files, function(i, file){
								fd.append(name, file);
							});
						} else {
							fd.append(name, dataURL);
						}
						// imageOptions
						fd.append('imageOptions', imageOptions);
						$.ajax({
							url: uploadUrl,
							type: 'POST',
							data: fd,
							contentType: false,
							processData: false,
							cache : false,
							success: function(html){
								photoAreaObj.html(html);
								// input type fileを空にするため置き換え
								fileObj.replaceWith(fileObj.clone(true));
								fileObj.val('');
								$('.btn').attr('disabled', false);
							},
							error: function(obj, error){
								photoAreaObj.html('');
								$('.btn').attr('disabled', false);
							}
						});
					},
					onError: function(error){
						photoAreaObj.html('<div class="error-message">jpg,gif,pngのみアップロードできます</div>');
						$('.btn').attr('disabled', false);
					}
				});
			});

			// 画像削除処理
			$(document).on('click', '.resizeAjaxImageDelBtn', function(){
				var container = $(this).closest(photoAreaSel);
				var fileInput = container.next('input:file');
				container.html('<?php echo $this->Form->hidden("{$fieldName}_shouldDelete", ['value' => true]); ?>');
				fileInput.replaceWith(fileInput = fileInput.clone(true));
				return false;
			});

		});
	<?php $this->Minify->scriptEnd(); ?>
<?php echo $this->Html->scriptEnd(); ?>
