<?php
	// 以下の変数が必要
	// $parentTableName
	// $childTableName
	// $imageField
	// $wrapperClass
	// $templateId

	// ajax uploadするURL, FIELDNAMEはjsで置換
	$uploadUrl = $this->Url->build("/cbase/uploader/nupload/{$parentTableName}/FIELDNAME");

	// input file id
	$uid = uniqid();
	$fileId = "nUpload_{$uid}";
	$loaderId = "nUploadLoader_{$uid}";
	$errorId = "nUploadError_{$uid}";
?>

<?php echo $this->Html->script('/cbase/js/jquery.inputFileResizer', ['block' => false]); ?>
<?php $this->Html->scriptStart(['block' => false]); ?>
	<?php $this->Minify->scriptStart(); ?>
		jQuery(function($){
			var fileSel = '#<?php echo $fileId; ?>';
			var loaderSel = '#<?php echo $loaderId; ?>';
			var errorSel = '#<?php echo $errorId; ?>';
			var uploadUrl = '<?php echo $uploadUrl; ?>';
			var wrapperSel = '.<?php echo $wrapperClass; ?>';
			var templateSel = '#<?php echo $templateId; ?>';
			var placeHolder = "<li class='nHolder'><div></div></li>";

			// templateフォームはdisableに
			$(templateSel).find(':input').prop('disabled', true);

			// dragsort
			$(wrapperSel).children('ul').dragsort({
				placeHolderTemplate: placeHolder
			});

			var showLoading = function() {
				$(fileSel).hide();
				$(loaderSel).show();
			};
			var hideLoading = function() {
				$(fileSel).show();
				$(loaderSel).hide();
			};

			// ブロック追加時にliに付加するidを求める
			var getNewListId = function() {
				var idCnt = -1;
				if ($(wrapperSel).find('li').length > 0) {
					// if blocks exists, get existing blocks max id + 1
					$(wrapperSel).find('li').each(function(){
						if(idCnt < parseInt($(this).attr('id'))){
							idCnt = parseInt($(this).attr('id'));
						}
					});
					idCnt += 1;
				} else {
					idCnt = 0;
				}
				return idCnt;
			};

			// ブロックを生成し追加
			var createBlock = function(imageHtml) {
				var key = getNewListId();
				var html = $(templateSel).html();
				html = html.replace(/NNN/g, key);
				var obj = jQuery('<div>' + html + '</div>');
				obj.find(':input').removeAttr('disabled');

				// imageを付加
				obj.find('#image').html(imageHtml);

				var block = "<li id='" + key + "'><div>" + obj.html() + "</div></li>";
				$(wrapperSel).children('ul').append(block);
			};

			// 写真が選択されたときにリサイズ
			$(document).on('change', fileSel, function(){
				var that = this;
				var fileObj = $(this);

				$(errorSel).html('');
				showLoading();

				// submitされないように全てのボタンはdisable
				$('.btn').attr('disabled', true);

				// ここでfieldNameを作る
				var fieldName = '<?php echo $childTableName; ?>.' + getNewListId() + '.<?php echo $imageField; ?>';

				$(this).inputFileResizer({
					onStart: function(){
						//
					},
					onComplete: function(dataURL, dispImg, file){
						// ajaxでファイルのみPOST
						var fd = new FormData();
						var name = fieldName + '_file';
						if (!dataURL && !dispImg && !file) {
							// gifの場合リサイズ処理せず全てnullで返ってくる
							var files = that.files;
							$.each(files, function(i, file){
								fd.append(name, file);
							});
						} else {
							fd.append(name, dataURL);
						}
						$.ajax({
							url: uploadUrl.replace('FIELDNAME', fieldName),
							type: 'POST',
							data: fd,
							contentType: false,
							processData: false,
							cache : false,
							success: function(html){
								createBlock(html);

								// input type fileを空にするため置き換え
								fileObj.replaceWith(fileObj.clone(true));
								fileObj.val('');
								hideLoading();
								$('.btn').attr('disabled', false);
							},
							error: function(obj, error){
								hideLoading();
								$('.btn').attr('disabled', false);
							}
						});
					},
					onError: function(error){
						$(errorSel).html('<div class="error-message">jpg,gif,pngのみアップロードできます</div>');
						hideLoading();
						$('.btn').attr('disabled', false);
					}
				});
			});

			// ブロック削除
			$(document).on('click', '.nBlockClose', function(){
				$(this).closest('li').remove();
			});

		});
	<?php $this->Minify->scriptEnd(); ?>
<?php echo $this->Html->scriptEnd(); ?>

<div>
	<input type="file" name="nUpload" id="<?php echo $fileId; ?>">
	<?php echo $this->Html->image('/cbase/js/nupload/ajax-loader.gif', ['style' => 'display:none;', 'id' => $loaderId]); ?>
</div>
<div id="<?php echo $errorId; ?>">
</div>