<?php
namespace Cbase\Controller;

use App\Controller\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;
use Cake\Utility\Inflector;

class UploaderController extends AppController
{

    /**
     * helpers
     */
    public $helpers = ['Cbase.Minify', 'Cbase.Cform'];

    /*
     * beforeFilter
     */
    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);

        // 認証なし
        $this->Auth->allow();
    }

    /**
     * UPするAjax
     * @param postでファイルurlデータとimageOptions(画像の場合)が送られる
     */
    public function upload($tableName = null, $fieldNameEnc = null)
    {
        $this->viewBuilder()->layout('ajax');

        if (empty($tableName) || empty($fieldNameEnc)) {
            die();
        }
        $originalFieldName = urldecode($fieldNameEnc);
        $fieldName = $originalFieldName . '_file';

        // hasManyかどうか
        $isHasMany = (strpos($originalFieldName, '.') !== false);

        // hasManyの際はrequest->dataの.が_つなぎの名称になっているので
        // 正しい形にする&patchEntityのためのoptionsを指定
        $paramName = $isHasMany ? str_replace('.', '_', $fieldName) : $fieldName;
        if (empty($this->request->data[$paramName])) {
            die();
        }
        $data = $this->request->data;
        $options = [];
        if ($isHasMany) {
            list($tn, $key, $fn) = explode('.', $fieldName);
            $data[$tn][$key][$fn] = $this->request->data[$paramName];
            $options = ['associated' => [$this->_cameled($tn)]];
        }

        $table = TableRegistry::get($tableName);
        $formEntity = $table->newEntity();
        $formEntity = $table->patchEntity($formEntity, $data, $options);
        $this->set(compact('originalFieldName', 'formEntity'));

        // imageOptions
        if (isset($this->request->data['imageOptions'])) {
            $this->set('imageOptions', json_decode($this->request->data['imageOptions'], true));
        }

        // template指定あればそれ表示
        if (!empty($this->request->data['template'])) {
            // $this->render($this->request->data['template']);
            // Users.uploadなどplugin.controller.actionを判別
            switch (substr_count($this->request->data['template'], '.')) {
                case 2:
                    // plugin付き
                    list($plugin, $controller, $action) = explode('.', $this->request->data['template']);
                    $this->render("{$plugin}./{$controller}/{$action}");
                    break;
                case 1:
                    // pluginなし
                    list($controller, $action) = explode('.', $this->request->data['template']);
                    $this->render("/../Template/{$controller}/{$action}");
                    break;
            }
        }
    }

    /**
     * 画像N個アップ用
     */
    public function nupload($tableName = null, $fieldName = null)
    {
        $this->upload($tableName, $fieldName);
    }

    /**
     * Field名をIDのキャメルに変換
     *
     * @param string $fieldName
     * @return string
     */
    private function _cameled($fieldName)
    {
        $names = explode('.', $fieldName);
        $cameled = '';
        foreach($names as $name){
            $cameled .= Inflector::camelize($name);
        }

        return $cameled;
    }

}