<?php
namespace Cbase\Controller\Admin;

use App\Controller\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;
use Cake\Utility\Inflector;

class CbaseController extends AppController
{

    /**
     * Adminの各CRUD処理を行うTable
     * 各controllerで上書き可能
     */
    public $mainTable = null;

    /**
     * components
     */
    public $components = ['Paginator', 'Flash', 'Cbase.Private'];

    /**
     * helpers
     */
    public $helpers = ['Cbase.Minify', 'Cbase.Cform'];

    /**
     * PrivateComponentの設定
     */
    public $privateSettings = [
        'useConfirm' => false, // 確認,削除確認画面を使うか
        'inputPreview' => true, // 入力画面にプレビューボタンを表示させるか
    ];

    /**
     * Paginator設定
     */
    public $paginate = [
        'limit' => 20,
    ];

    /**
     * 確認画面かどうか
     */
    public $confirmForm = false;

    /*
     * beforeFilter
     */
    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);

        // mainTable
        $this->mainTable = $this->name;
    }

    /**
     * 一覧
     */
    public function index()
    {
        // 共通処理
        $this->Private->index();
        // ページネーション付きデータ取得し、viewに渡す
        $this->paginate = array_merge($this->paginate, $this->{$this->mainTable}->getOptions($this->request->query, true));
        $this->set('datas', $this->paginate($this->{$this->mainTable}));
    }

    /**
     * Ajax用公開非公開変更
     * POST [public] => 1, [id] => 1, [model] => Examples, [field] => public
     */
    public function changePublic()
    {
        $this->viewBuilder()->layout('ajax');
        $this->autoRender = false;
        if (
            empty($this->request->data['model'])
            || empty($this->request->data['id'])
            || empty($this->request->data['public'])
            || empty($this->request->data['field'])
        ) die('param error');
        $model = TableRegistry::get($this->request->data['model']);

        // データ取得（なければなにもしない）
        $data = $model->get($this->request->data['id']);
        if (empty($data->id)) die('nodata error');

        // 公開非公開の変更
        $data->{$this->request->data['field']} = $this->request->data['public'];
        if(!$model->save($data)) die('save error');
    }

    /**
     * 並び順変更
     */
    public function changeSequence() {
        $msgSuc = '並び順を変更しました';
        $msgErr = '並び順変更に失敗しました';
        $redirectUrl = !empty($this->request->data['redirect_url']) ? $this->request->data['redirect_url'] : '/admin/' . Inflector::underscore($this->request->data['model']);
        if (
            empty($this->request->data['model'])
            || empty($this->request->data['id'])
            || !isset($this->request->data['value'])
        ) {
            $this->Flash->set($msgErr);
            $this->redirect($redirectUrl);
        }
        $field = (empty($this->request->data['field'])) ? 'sequence' : $this->request->data['field'];
        $Model = TableRegistry::get($this->request->data['model']);

        // データ取得（なければなにもしない）
        $data = $Model->get($this->request->data['id']);
        if (empty($data->id)) {
            $this->Flash->set($msgErr);
            $this->redirect($redirectUrl);
        }

        // 変更
        $data->{$field} = $this->request->data['value'];
        if(!$Model->save($data)) {
            $this->Flash->set($msgErr);
            $this->redirect($redirectUrl);
        }
        $this->Flash->set($msgSuc);
        $this->redirect($redirectUrl . '?back=1');
    }

    /**
     * 詳細表示
     */
    public function show($id = null) {
        // 共通処理
        $this->Private->show($id);
    }

    /**
     * プレビュー
     */
    public function preview($id = null) {
    }

    /**
     * 登録
     */
    public function add()
    {
        // 共通処理
        $this->Private->add();
    }

    /**
     * コピー
     */
    public function copy($id = null)
    {
        // 共通処理
        $this->Private->copy($id, ['text' => ['title' => 'のコピー']]);
    }

    /**
     * 編集
     */
    public function edit($id = null)
    {
        // 共通処理
        $this->Private->edit($id);
    }

    /**
     * 確認
     */
    public function confirm()
    {
        // 共通処理
        $this->Private->confirm();
    }

    /**
     * 完了
     */
    public function complete()
    {
        // 共通処理
        $this->Private->complete();
    }

     /**
     * 削除確認
     */
    public function deleteConfirm($id = null)
    {
        // 共通処理
        $this->Private->deleteConfirm($id);
    }

    /**
     * 削除完了
     */
    public function deleteComplete($id = null)
    {
        // 共通処理
        $this->Private->deleteComplete($id);
    }

}
