<?php
require_once (dirname(__FILE__).'/../common/Cryptgram.php');
require_once (dirname(__FILE__).'/../common/GPayException.php');
require_once (dirname(__FILE__).'/../output/SearchRateAllDccOutput.php');
require_once (dirname(__FILE__).'/../tran/BaseTran.php');
/**
 * <b>多通貨クレジット決済（DCC)全レート照会　実行クラス</b>
 *
 * @package com.gmo_pg.client
 * @subpackage tran
 * @see tranPackageInfo.php
 * @author GMO PaymentGateway
 */
class SearchRateAllDcc extends BaseTran {

	/**
	 * コンストラクタ
	 */
	public function __construct() {
	    parent::__construct();
	}

	/**
	 * 全レート照会を実行する
	 *
	 * @param  SearchRateAllDccInput $input  入力パラメータ
	 * @return SearchRateAllDccOutput $output 出力パラメータ
	 * @exception GPayException
	 */
	public function exec(&$input) {

        // 接続しプロトコル呼び出し・結果取得
        $resultMap = $this->callProtocol($input->toString());
	    // 戻り値がnullの場合、nullを戻す
        if (is_null($resultMap)) {
		    return null;
        }

        // SearchRateAllDccOutput作成し、戻す
	    return new SearchRateAllDccOutput($resultMap);
	}
}
?>
