<?php
require_once (dirname(__FILE__).'/../input/BaseInput.php');
/**
 * <b>auかんたん決済継続課金取引登録　入力パラメータクラス</b>
 *
 * @package com.gmo_pg.client
 * @subpackage input
 * @see inputPackageInfo.php
 * @author GMO PaymentGateway
 * @version 1.0
 * @created 2012/02/15
 */
class EntryTranAuContinuanceInput extends BaseInput {

	/**
	 * @var string ショップID
	 */
	private $shopID;

	/**
	 * @var string ショップパスワード
	 */
	private $shopPass;

	/**
	 * @var string オーダーID
	 */
	private $orderID;

	/**
	 * @var string 課金利用金額
	 */
	private $amount;

	/**
	 * @var string 課金税送料
	 */
	private $tax;

	/**
	 * @var string 初回課金利用金額
	 */
	private $firstAmount;

	/**
	 * @var string 初回課金税送料
	 */
	private $firstTax;


	/**
	 * コンストラクタ
	 *
	 * @param array $params 入力パラメータ
	 */
	public function __construct($params = null) {
		parent::__construct($params);
	}


	/**
	 * ショップID取得
	 * @return string ショップID
	 */
	public function getShopID() {
		return $this->shopID;
	}

	/**
	 * ショップパスワード取得
	 * @return string ショップパスワード
	 */
	public function getShopPass() {
		return $this->shopPass;
	}

	/**
	 * オーダーID取得
	 * @return string オーダーID
	 */
	public function getOrderID() {
		return $this->orderID;
	}

	/**
	 * 課金利用金額取得
	 * @return integer 利用金額
	 */
	public function getAmount() {
		return $this->amount;
	}

	/**
	 * 課金税送料取得
	 * @return integer 税送料
	 */
	public function getTax() {
		return $this->tax;
	}

	/**
	 * 初回課金利用金額取得
	 * @return integer 利用金額
	 */
	public function getFirstAmount() {
		return $this->firstAmount;
	}

	/**
	 * 初回課金税送料取得
	 * @return integer 税送料
	 */
	public function getFirstTax() {
		return $this->firstTax;
	}

	/**
	 * ショップID設定
	 *
	 * @param string $shopID
	 */
	public function setShopID($shopID) {
		$this->shopID = $shopID;
	}

	/**
	 * ショップパスワード設定
	 *
	 * @param string $shopPass
	 */
	public function setShopPass($shopPass) {
		$this->shopPass = $shopPass;
	}

	/**
	 * オーダーID設定
	 *
	 * @param string $orderID
	 */
	public function setOrderID($orderID) {
		$this->orderID = $orderID;
	}

	/**
	 * 課金利用金額設定
	 *
	 * @param integer $amount
	 */
	public function setAmount($amount) {
		$this->amount = $amount;
	}

	/**
	 * 課金税送料設定
	 *
	 * @param integer $tax
	 */
	public function setTax($tax) {
		$this->tax = $tax;
	}

	/**
	 * 初回課金利用金額設定
	 *
	 * @param integer $firstAmount
	 */
	public function setFirstAmount($firstAmount) {
		$this->firstAmount = $firstAmount;
	}

	/**
	 * 初回課金税送料設定
	 *
	 * @param integer $firstTax
	 */
	public function setFirstTax($firstTax) {
		$this->firstTax = $firstTax;
	}


	/**
	 * デフォルト値設定
	 */
	public function setDefaultValues() {

	}

	/**
	 * 入力パラメータ群の値を設定する
	 *
	 * @param IgnoreCaseMap $params 入力パラメータ
	 */
	public function setInputValues($params) {
		// 入力パラメータがnullの場合は設定処理を行わない
	    if (is_null($params)) {
	        return;
	    }

	    $this->setShopID($this->getStringValue($params, 'ShopID', $this->getShopID()));
	    $this->setShopPass($this->getStringValue($params, 'ShopPass', $this->getShopPass()));
	    $this->setOrderID($this->getStringValue($params, 'OrderID', $this->getOrderID()));
	    $this->setJobCd($this->getStringValue($params, 'JobCd', $this->getJobCd()));
	    $this->setAmount($this->getStringValue($params, 'Amount', $this->getAmount()));
	    $this->setTax($this->getStringValue($params, 'Tax', $this->getTax()));
	    $this->setFirstAmount($this->getStringValue($params, 'FirstAmount', $this->getFirstAmount()));
	    $this->setFirstTax($this->getStringValue($params, 'FirstTax', $this->getFirstTax()));
	}

	/**
	 * 文字列表現
	 * @return string 接続文字列表現
	 */
	public function toString() {
		$str ='';
		$str .= 'ShopID=' . $this->encodeStr($this->getShopID());
	    $str .= '&';
	    $str .= 'ShopPass=' . $this->encodeStr($this->getShopPass());
	    $str .= '&';
	    $str .= 'OrderID=' . $this->encodeStr($this->getOrderID());
	    $str .= '&';
	    $str .= 'Amount=' . $this->encodeStr($this->getAmount());
	    $str .= '&';
	    $str .= 'Tax=' . $this->encodeStr($this->getTax());
	    $str .= '&';
	    $str .= 'FirstAmount=' . $this->encodeStr($this->getFirstAmount());
	    $str .= '&';
	    $str .= 'FirstTax=' . $this->encodeStr($this->getFirstTax());

	    return $str;
	}


}
?>