<?php
require_once dirname(__FILE__).'/../input/EntryTranMerpayInput.php';
require_once dirname(__FILE__).'/../input/ExecTranMerpayInput.php';
/**
 * <b>メルペイ登録・決済一括実行　入力パラメータクラス</b>
 *
 * @package com.gmo_pg.client
 * @subpackage input
 * @see inputPackageInfo.php
 * @author GMO PaymentGateway
 */
class EntryExecTranMerpayInput {

	/**
	 * @var EntryTranMerpayInput メルペイ登録入力パラメータ
	 */
	private $entryTranMerpayInput;/* @var $entryTranInput EntryTranMerpayInput */

	/**
	 * @var ExecTranMerpayInput メルペイ実行入力パラメータ
	 */
	private $execTranMerpayInput;/* @var $execTranInput ExecTranMerpayInput */

	/**
	 * コンストラクタ
	 *
	 * @param array $params    入力パラメータ
	 */
	public function __construct($params = null) {
		$this->entryTranMerpayInput = new EntryTranMerpayInput($params);
		$this->execTranMerpayInput = new ExecTranMerpayInput($params);
	}

	/**
	 * メルペイ取引登録入力パラメータ取得
	 *
	 * @return EntryTranMerpayInput 取引登録時パラメータ
	 */
	public function &getEntryTranMerpayInput() {
		return $this->entryTranMerpayInput;
	}

	/**
	 * メルペイ実行入力パラメータ取得
	 * @return ExecTranMerpayInput 決済実行時パラメータ
	 */
	public function &getExecTranMerpayInput() {
		return $this->execTranMerpayInput;
	}

	/**
	 * ショップID取得
	 * @return string ショップID
	 */
	public function getShopID() {
		return $this->entryTranMerpayInput->getShopID();

	}
	/**
	 * ショップパスワード取得
	 * @return string ショップパスワード
	 */
	public function getShopPass() {
		return $this->entryTranMerpayInput->getShopPass();

	}
	/**
	 * オーダーID取得
	 * @return string オーダーID
	 */
	public function getOrderID() {
		return $this->entryTranMerpayInput->getOrderID();

	}
	/**
	 * 処理区分取得
	 * @return string 処理区分
	 */
	public function getJobCd() {
		return $this->entryTranMerpayInput->getJobCd();
	}
	/**
	 * 利用金額取得
	 * @return integer 利用金額
	 */
	public function getAmount() {
		return $this->entryTranMerpayInput->getAmount();
	}
	/**
	 * 税送料取得
	 * @return integer 税送料
	 */
	public function getTax() {
		return $this->entryTranMerpayInput->getTax();
	}
	/**
	 * 取引ID取得
	 * @return string 取引ID
	 */
	public function getAccessID() {
		return $this->execTranMerpayInput->getAccessID();
	}
	/**
	 * 取引パスワード取得
	 * @return string 取引パスワード
	 */
	public function getAccessPass() {
		return $this->execTranMerpayInput->getAccessPass();
	}
	/**
	 * 商品カテゴリID取得
	 * @return string 商品カテゴリID
	 */
	public function getItemCategoryId() {
		return $this->execTranMerpayInput->getItemCategoryId();
	}
	/**
	 * 商品情報一覧取得
	 * @return string 商品情報一覧
	 */
	public function getMultiItem() {
		return $this->execTranMerpayInput->getMultiItem();
	}
	/**
	 * ユーザーエージェント取得
	 * @return string ユーザーエージェント
	 */
	public function getHttpUserAgent() {
		return $this->execTranMerpayInput->getHttpUserAgent();
	}
	/**
	 * 加盟店自由項目1取得
	 * @return string 加盟店自由項目1
	 */
	public function getClientField1() {
		return $this->execTranMerpayInput->getClientField1();
	}
	/**
	 * 加盟店自由項目2取得
	 * @return string 加盟店自由項目2
	 */
	public function getClientField2() {
		return $this->execTranMerpayInput->getClientField2();
	}
	/**
	 * 加盟店自由項目3取得
	 * @return string 加盟店自由項目3
	 */
	public function getClientField3() {
		return $this->execTranMerpayInput->getClientField3();
	}
	/**
	 * 決済完了後の戻り先URL取得
	 * @return string 決済完了後の戻り先URL
	 */
	public function getRetURL() {
		return $this->execTranMerpayInput->getRetURL();
	}
	/**
	 * ユーザー端末情報取得
	 * @return string ユーザー端末情報
	 */
	public function getUserInfo() {
		return $this->execTranMerpayInput->getUserInfo();
	}

	/**
	 * メルペイ取引登録入力パラメータ設定
	 *
	 * @param EntryTranMerpayInput entryTranMerpayInput  取引登録入力パラメータ
	 */
	public function setEntryTranMerpayInput(&$entryTranMerpayInput) {
		$this->entryTranMerpayInput = $entryTranMerpayInput;
	}

	/**
	 * メルペイ実行入力パラメータ設定
	 *
	 * @param ExecTranMerpayInput  execTranMerpayInput   決済実行入力パラメータ
	 */
	public function setExecTranMerpayInput(&$execTranMerpayInput) {
		$this->execTranMerpayInput = $execTranMerpayInput;
	}

	/**
	 * ショップID設定
	 *
	 * @param string $shopID
	 */
	public function setShopID($shopID) {
		$this->entryTranMerpayInput->setShopID($shopID);
		$this->execTranMerpayInput->setShopID($shopID);

	}
	/**
	 * ショップパスワード設定
	 *
	 * @param string $shopPass
	 */
	public function setShopPass($shopPass) {
		$this->entryTranMerpayInput->setShopPass($shopPass);
		$this->execTranMerpayInput->setShopPass($shopPass);

	}
	/**
	 * オーダーID設定
	 *
	 * @param string $orderID
	 */
	public function setOrderID($orderID) {
		$this->entryTranMerpayInput->setOrderID($orderID);
		$this->execTranMerpayInput->setOrderID($orderID);

	}
	/**
	 * 処理区分設定
	 *
	 * @param string $jobCd
	 */
	public function setJobCd($jobCd) {
		$this->entryTranMerpayInput->setJobCd($jobCd);
	}
	/**
	 * 利用金額設定
	 *
	 * @param integer $amount
	 */
	public function setAmount($amount) {
		$this->entryTranMerpayInput->setAmount($amount);
	}
	/**
	 * 税送料設定
	 *
	 * @param integer $tax
	 */
	public function setTax($tax) {
		$this->entryTranMerpayInput->setTax($tax);
	}
	/**
	 * 取引ID設定
	 *
	 * @param string $accessID
	 */
	public function setAccessID($accessID) {
		$this->execTranMerpayInput->setAccessID($accessID);
	}
	/**
	 * 取引パスワード設定
	 *
	 * @param string $accessPass
	 */
	public function setAccessPass($accessPass) {
		$this->execTranMerpayInput->setAccessPass($accessPass);
	}
	/**
	 * 商品カテゴリID設定
	 *
	 * @param string $itemCategoryId
	 */
	public function setItemCategoryId($itemCategoryId) {
		$this->execTranMerpayInput->setItemCategoryId($itemCategoryId);
	}
	/**
	 * 商品情報一覧設定
	 *
	 * @param string $multiItem
	 */
	public function setMultiItem($multiItem) {
		$this->execTranMerpayInput->setMultiItem($multiItem);
	}
	/**
	 * ユーザーエージェント設定
	 *
	 * @param string $httpUserAgent
	 */
	public function setHttpUserAgent($httpUserAgent) {
		$this->execTranMerpayInput->setHttpUserAgent($httpUserAgent);
	}
	/**
	 * 加盟店自由項目1設定
	 *
	 * @param string $clientField1
	 */
	public function setClientField1($clientField1) {
		$this->execTranMerpayInput->setClientField1($clientField1);
	}
	/**
	 * 加盟店自由項目2設定
	 *
	 * @param string $clientField2
	 */
	public function setClientField2($clientField2) {
		$this->execTranMerpayInput->setClientField2($clientField2);
	}
	/**
	 * 加盟店自由項目3設定
	 *
	 * @param string $clientField3
	 */
	public function setClientField3($clientField3) {
		$this->execTranMerpayInput->setClientField3($clientField3);
	}
	/**
	 * 決済完了後の戻り先URL設定
	 *
	 * @param string $retURL
	 */
	public function setRetURL($retURL) {
		$this->execTranMerpayInput->setRetURL($retURL);
	}
	/**
	 * ユーザー端末情報設定
	 *
	 * @param string $userInfo
	 */
	public function setUserInfo($userInfo) {
		$this->execTranMerpayInput->setUserInfo($userInfo);
	}

}
?>
