<?php


namespace FileMaker\Dto;


use Subscription\Dto\AbsDto;

/**
 * FileMakerの実行結果DTO
 *
 * Class FmResponseDto
 * @package FileMaker\Dto
 */
class FmResponseDto extends AbsDto
{
    /**
     * エラー内容
     * @var array
     */
    public $errorList;

    /**
     * 入力データー
     *
     * @var array
     */
    public $requestData;

    /**
     * エラーの判定
     *
     * @return bool
     */
    public function isError() {
        return !is_null($this->errorList) && 0 != count($this->errorList);
    }
}