<?php

namespace Subscription\Dto;

/**
 * Class AbsDto
 * @package Subscription\Dto
 */
abstract class AbsDto
{
    /**
     * @param $name
     * @param $args
     * @return mixed
     */
    public function __call($name, $args) {
        if (strncmp($name, 'get', 3) === 0) {
            $pascalCName = substr($name, 3);
            $snakeCName = $this->pascalCase2SnakeCase($pascalCName);

            if (property_exists($this, $snakeCName)) {
                return $this->{$snakeCName};
            }
        } else if (strncmp($name, 'set', 3) === 0) {
            $pascalCName = substr($name, 3);
            $snakeCName = $this->pascalCase2SnakeCase($pascalCName);

            if (property_exists($this, $snakeCName)) {
                return $this->{$snakeCName} = reset($args);
            }
        }
        throw new \BadMethodCallException('Method "'.$name.'" does not exist.');
    }

    /**
     * @param $key
     * @param $value
     */
    public function __set($key, $value){
        if ($this->existsProperty($key)) {
            $this->{$key} = $value;
        }
        throw new \BadMethodCallException('Method "'.$key.'" does not exist.');
    }

    /**
     * @param $key
     * @return mixed
     */
    public function __get($key)
    {
        if ($this->existsProperty($key)) {
            return $this->{$key};
        }
        throw new \BadMethodCallException('Method "'.$key.'" does not exist.');
    }

    /**
     * @param $input
     * @return string
     */
    private function pascalCase2SnakeCase($input) {
        preg_match_all('!([A-Z][A-Z0-9]*(?=$|[A-Z][a-z0-9])|[A-Za-z][a-z0-9]+)!', $input, $matches);
        $ret = $matches[0];
        foreach ($ret as &$match) {
            $match = $match == strtoupper($match) ? strtolower($match) : lcfirst($match);
        }
        return implode('_', $ret);
    }

    /**
     * @param $propertyName
     * @return bool
     */
    private function existsProperty($propertyName) {
        $reflection = new \ReflectionObject($this);
        $properties = $reflection->getProperties(\ReflectionProperty::IS_PUBLIC);
        foreach ($properties as $property) {
            if ($property->getName() === $propertyName) return true;
        }
        return false;
    }
}
