<?php

namespace Paidy\Services;

use Paidy\Dto\PaidyCaptureResultDto;
use Paidy\Dto\PaidyPaymentDto;
use Paidy\Configs\PaidyConfig;
use Paidy\Dto\PaidyPaymentResultDto;

/**
 * Class PaidyApiService
 * @package Paidy\Services
 */
class PaidyApiService
{
    /**
     * 決済APIのURL
     */
    const URL_PAYMENTS = 'https://api.paidy.com/payments';

    /**
     * 決済を実行
     *
     * @param PaidyPaymentDto $importData
     * @return PaidyPaymentResultDto
     */
    public static function pay(PaidyPaymentDto $importData)
    {
        $ch = curl_init(self::URL_PAYMENTS);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, self::getPostHeader());
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($importData));
        curl_setopt($ch, CURLOPT_HEADER, true);
        $response = curl_exec($ch);

        // header & body 取得
        // ヘッダサイズ取得
        $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
        // headerだけ切り出し
        $header = substr($response, 0, $header_size);
        // bodyだけ切り出し
        $body = substr($response, $header_size);

        // json形式で返ってくるので、配列に変換
        $result = json_decode($body, true);

        curl_close($ch);

        $dto = new PaidyPaymentResultDto();
        $dto->received($importData, $result);
        return $dto;
    }

    /**
     * ヘッダーの設定
     *
     * @return array
     */
    private static function getPostHeader() {
        return array(
            'Content-Type: application/json;charset=utf-8',
            'Paidy-Version: 2018-04-10',
            'Authorization: Bearer ' . PaidyConfig::getSecurityKey()
        );
    }

    public static function capture(PaidyPaymentResultDto $paymentResultDto)
    {
        $url = self::URL_PAYMENTS . "/{$paymentResultDto->getPaymentId()}/captures";
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, self::getPostHeader());
        curl_setopt($ch, CURLOPT_POSTFIELDS, '{}');
        curl_setopt($ch, CURLOPT_HEADER, true);
        $response = curl_exec($ch);

        // header & body 取得
        // ヘッダサイズ取得
        $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
        // headerだけ切り出し
        $header = substr($response, 0, $header_size);
        // bodyだけ切り出し
        $body = substr($response, $header_size);

        // json形式で返ってくるので、配列に変換
        $result = json_decode($body, true);

        curl_close($ch);
        $captureResultDto = new PaidyCaptureResultDto();
        $captureResultDto->received($paymentResultDto, $result);
        return $captureResultDto;
    }
}
