<?php

namespace Paidy\Configs;



/**
 * Paidyの環境
 *
 * Class PaidyConfig
 * @package Paidy\Configs
 */
class PaidyConfig
{
    /**
     * インスタンス
     * @var PaidyConfig
     */
    private static $instance;

    /**
     * テストの可否
     * @var bool
     */
    private $isTrial;

    /**
     * パブリックキー
     * @var string
     */
    private $publicKey;

    /**
     * シークレットキー
     * @var string
     */
    private $securityKey;

    /**
     * ショップ名
     * @var string
     */
    private $storeName;

    /**
     * PaidyConfig constructor.
     */
    private function __construct()
    {
    }

    /**
     * テストの可否の取得
     *
     * @return bool
     */
    public static function isTrial()
    {
        $self = self::$instance;
        if (is_null($self)) {
            throw new \RuntimeException('Not set configuration!!');
        }
        return $self->isTrial;
    }

    /**
     * テストの可否を設定
     *
     * @param bool $isTrial
     */
    public static function setIsTrial($isTrial)
    {
        $self = self::getInstance();
        $self->isTrial = $isTrial;
    }

    /**
     * パブリックキーを設定
     *
     * @param string $publicKey
     */
    public static function setPublicKey($publicKey) {
        $self = self::getInstance();
        $self->publicKey = $publicKey;
    }

    /**
     * パブリックキーを取得
     *
     * @return string
     */
    public static function getPublicKey() {
        $self = self::$instance;
        if (is_null($self)) {
            throw new \RuntimeException('Not set configuration!!');
        }
        return $self->publicKey;
    }

    /**
     * シークレットキーを設定
     *
     * @param string $securityKey
     */
    public static function setSecurityKey($securityKey) {
        $self = self::getInstance();
        $self->securityKey = $securityKey;
    }

    /**
     * シークレットキーを取得
     *
     * @return string
     */
    public static function getSecurityKey() {
        $self = self::$instance;
        if (is_null($self)) {
            throw new \RuntimeException('Not set configuration!!');
        }
        return $self->securityKey;
    }

    /**
     * @return string
     */
    public static function getStoreName()
    {
        $self = self::$instance;
        if (is_null($self)) {
            throw new \RuntimeException('Not set configuration!!');
        }
        return $self->storeName;
    }

    /**
     * @param string $storeName
     */
    public static function setStoreName(string $storeName)
    {
        $self = self::getInstance();
        $self->storeName = $storeName;
    }

    /**
     * インスタンスを作成・取得
     *
     * @return PaidyConfig
     */
    public static function getInstance() {
        if (is_null(self::$instance)) {
            self::$instance = new PaidyConfig();
        }

        return self::$instance;
    }
}