<?php
require_once (dirname(__FILE__).'/../common/Cryptgram.php');
require_once (dirname(__FILE__).'/../common/GPayException.php');
require_once (dirname(__FILE__).'/../output/HistoryWebmoneyQuickIdOutput.php');
require_once (dirname(__FILE__).'/../tran/BaseTran.php');
/**
 * <b>WebmoneyクイックID利用明細URL取得　実行クラス</b>
 *
 * @package com.gmo_pg.client
 * @subpackage tran
 * @see tranPackageInfo.php
 * @author GMO PaymentGateway
 */
class HistoryWebmoneyQuickId extends BaseTran {

	/**
	 * コンストラクタ
	 */
	public function __construct() {
	    parent::__construct();
	}

	/**
	 * クイックID利用明細URL取得を実行する
	 *
	 * @param  HistoryWebmoneyQuickIdInput $input  入力パラメータ
	 * @return HistoryWebmoneyQuickIdOutput $output 出力パラメータ
	 * @exception GPayException
	 */
	public function exec(&$input) {

        // 接続しプロトコル呼び出し・結果取得
        $resultMap = $this->callProtocol($input->toString());
	    // 戻り値がnullの場合、nullを戻す
        if (is_null($resultMap)) {
		    return null;
        }

        // HistoryWebmoneyQuickIdOutput作成し、戻す
	    return new HistoryWebmoneyQuickIdOutput($resultMap);
	}
}
?>
