<?php

namespace FileMaker\Configs;


use Subscription\Dto\AbsDto;

/**
 * FileMakerの環境
 *
 * Class FmConfig
 * @package FileMaker\Configs
 */
class FmConfig extends AbsDto
{
    /**
     * APIのURL
     * @var
     */
    public $apiUrl;

    /**
     * Basic認証のID
     * @var
     */
    public $basicUserId;

    /**
     * Basic認証のパスワード
     * @var
     */
    public $basicPassword;

    /**
     * ログインID
     * @var
     */
    public $authUserId;

    /**
     * ログインパスワード
     * @var
     */
    public $authPassword;

    /**
     * 商材区分
     * @var
     */
    public $productKbn;

    /**
     * 以下の形式の配列でインスタンスを返す。
     * [
     *     'api_url' => '',
     *     'basic' => [
     *         'user_id' => '',
     *         'password' => '',
     *     ],
     *     'auth' => [
     *         'user_id' => '',
     *         'password' => '',
     *     ],
     *     'product_kbn' => ''
     * ]
     * @param array $config
     * @return FmConfig
     */
    public static function getInstance(array $config) {
        $fmConfig = new FmConfig();
        $fmConfig->apiUrl = array_get($config, 'api_url');
        $fmConfig->basicUserId = array_get($config, 'basic.user_id');
        $fmConfig->basicPassword = array_get($config, 'basic.password');
        $fmConfig->authUserId = array_get($config, 'auth.user_id');
        $fmConfig->authPassword = array_get($config, 'auth.password');
        $fmConfig->productKbn = array_get($config, 'product_kbn');
        return $fmConfig;
    }
}