<?php

namespace Paidy\Dto;

use Subscription\Dto\AbsDto;

/**
 * Paidyの決済の結果DTO
 * Class PaidyPaymentResultDto
 */
class PaidyPaymentResultDto extends AbsDto
{
    /**
     * TokenのID
     * @var PaidyPaymentDto
     */
    public $paidyPayment;

    /**
     * @var
     */
    public $is_error;

    /**
     * エラーメッセージ
     * @var
     */
    public $message;

    private $result;

    /**
     * @param PaidyPaymentDto $paidyPayment
     * @param array $result
     */
    public function received(PaidyPaymentDto $paidyPayment, array $result)
    {
        $this->paidyPayment = $paidyPayment;
        $this->result = $result;

        if ($this->result['status'] == 'authorized' || $this->result['status'] == '200') {
            $this->is_error = false;
        } elseif ($this->result['status'] == 'rejected') {
            $this->message = 'Paidyエラー: Rejected';
            $this->is_error = true;
        } else {
            $this->message = 'Paidyエラー:' . $this->result['title'];
            $this->is_error = true;
        }
    }

    public function getPaymentId()
    {
        return $this->result['id'];
    }
}
