<?php

namespace Paidy\Dto;

use Subscription\Dto\AbsDto;

/**
 * Paidyのキャプチャの結果DTO
 * Class PaidyCaptureResultDto
 */
class PaidyCaptureResultDto extends AbsDto
{
    /**
     * TokenのID
     * @var PaidyPaymentResultDto
     */
    public $paidyPaymentResult;

    /**
     * @var
     */
    public $is_error;

    /**
     * エラーメッセージ
     * @var
     */
    public $message;

    private $result;

    /**
     * @param PaidyPaymentResultDto $paidyPaymentResultDto
     * @param array $result
     * @return bool
     */
    public function received(PaidyPaymentResultDto $paidyPaymentResultDto, array $result)
    {
        $this->paidyPaymentResult = $paidyPaymentResultDto;
        $this->result = $result;

        if ($this->result['status'] == 'closed' || $this->result['status'] == '200') {
            $this->is_error = false;
            return true;
        }
        
        $this->message = 'Paidyエラー:' . $this->result['title'];
        $this->is_error = true;
        return false;
    }
}
