<?php

namespace Paidy\Dto;

use Subscription\Dto\AbsDto;

/**
 * Paidyのコンシューマーの購入履歴に関する情報
 * Class PaidyBuyerDataDto
 */
class PaidyBuyerDataDto extends AbsDto
{
    /**
     * コンシューマーがマーチャントの店舗でアカウントを作成してから経過した日数
     * @var int
     */
    public $age;

    /**
     * コンシューマーがマーチャントと取引を開始してから現在までに行った注文総数
     * @var int
     */
    public $order_count;

    /**
     * コンシューマーがマーチャントと取引を開始してから現在までに行った注文の総額（円）
     * @var double
     */
    public $ltv;

    /**
     * 最後に行った注文の金額（円）
     * @var double
     */
    public $last_order_amount;

    /**
     * コンシューマーが最後に注文してから経過した日数
     * @var int
     */
    public $last_order_at;
}
