<?php

use GMO\Configs\GmoConfig;
use Paidy\Configs\PaidyConfig;

if (! function_exists('wiz_subs_base_path'))
{
    /**
     * ワイズサブスクリプションのベースPath
     *
     * @return string
     */
    function wiz_subs_base_path()
    {
        return __DIR__ . '/../..';
    }
}

if (! function_exists('gmo_token_js_url'))
{
    /**
     * GMOのカード情報のToken取得URL
     *
     * @return string
     */
    function gmo_token_js_url()
    {
        return GmoConfig::getTokenJsUrl();
    }
}

if (! function_exists('gmo_shop_id'))
{
    /**
     * GMOのショップID
     *
     * @return string
     */
    function gmo_shop_id()
    {
        return GmoConfig::getShopId();
    }
}

if (! function_exists('include_gmo_js'))
{
    /**
     * GMOのJSをインクルード
     *
     * @return string
     */
    function include_gmo_js()
    {
        include wiz_subs_base_path() . '/resources/templates/include_gmo_cd_token_js.php';
    }
}

if (! function_exists( 'paidy_public_key'))
{
    /**
     * Paidyのパブリックキーを取得
     *
     * @return string
     */
    function paidy_public_key()
    {
        return PaidyConfig::getPublicKey();
    }
}

if (! function_exists( 'paidy_is_trial'))
{
    /**
     * Paidyのテストかどうか
     *
     * @return string
     */
    function paidy_is_trial()
    {
        return PaidyConfig::isTrial();
    }
}

if (! function_exists( 'paidy_store_name'))
{
    /**
     * Paidyのショップ名
     *
     * @return string
     */
    function paidy_store_name()
    {
        return PaidyConfig::getStoreName();
    }
}

if (! function_exists('include_paidy_js'))
{
    /**
     * PaidyのJSをインクルード
     *
     * @return string
     */
    function include_paidy_js()
    {
        include wiz_subs_base_path() . '/resources/templates/include_paidy_checkout_js.php';
    }
}

if (! function_exists('array_get')) {
    /**
     * Get an item from an array using "dot" notation.
     *
     * @param  array  $data
     * @param  string  $key
     * @param  mixed   $default
     * @return mixed
     */
    function array_get($data, $key, $default = null)
    {
        // @assert $key is a non-empty string
        // @assert $data is a loopable array
        // @otherwise return $default value
        if (!is_string($key) || empty($key) || !count($data))
        {
            return $default;
        }

        // @assert $key contains a dot notated string
        if (strpos($key, '.') !== false)
        {
            $keys = explode('.', $key);

            foreach ($keys as $innerKey)
            {
                // @assert $data[$innerKey] is available to continue
                // @otherwise return $default value
                if (!array_key_exists($innerKey, $data))
                {
                    return $default;
                }

                $data = $data[$innerKey];
            }

            return $data;
        }

        // @fallback returning value of $key in $data or $default value
        return array_key_exists($key, $data) ? $data[$key] : $default;
    }
}