<?php

namespace GMO\Services\CreditCard;

use GMO\Configs\GmoConfig;
use GMO\Constants\JobCd;
use GMO\Inputs\EntryTranInput;
use GMO\Inputs\ExecTranInput;
use GMO\Outputs\EntryTranOutput;
use GMO\Outputs\ExecTranOutput;
use GMO\Trans\EntryTran;
use GMO\Trans\ExecTran;
use Illuminate\Support\Facades\Log;

/**
 * Class SimpleAuthorizationService
 * @package GMO\Services\CreditCard
 */
class SimpleAuthorizationService
{
    /**
     * オーソリティー
     *
     * @param string $orderId
     * @param string $token
     * @param int $amount
     * @return ExecTranOutput
     * @throws \GMO\Commons\GPayException
     * @throws \ReflectionException
     */
    public function auth(string $orderId, string $token, int $amount) {
        // 取引登録の処理
        $entryRes = $this->entry($orderId, $amount);
        if ($entryRes->isErrorOccurred()) {
            // 取引登録処理が失敗の場合、エラー内容を格納
            // 結果を初期化
            $paymentRes = new ExecTranOutput();
            $paymentRes->setOrderId($orderId);
            $paymentRes->setMethod(1);
            $paymentRes->setErrList($entryRes->getErrList());

            return $paymentRes;
        } else {
            // 取引登録処理の結果で決済処理を行う
            $paymentRes = $this->payment($entryRes, $orderId, $token);
        }

        return $paymentRes;
    }

    /**
     * @param string $orderId
     * @param int $amount
     * @return EntryTranOutput
     * @throws \GMO\Commons\GPayException
     * @throws \ReflectionException
     */
    protected function entry(string $orderId, int $amount) {
        //入力パラメータクラスをインスタンス化します
        $entryInput = new EntryTranInput();
        //このサンプルでは、ショップID・パスワードはコンフィグファイルで
        //定数defineしています。
        $entryInput->setShopId(GmoConfig::getShopId());
        $entryInput->setShopPass( GmoConfig::getShopPassword());

        //各種パラメータを設定しています。
        //実際には、処理区分や利用金額、オーダーIDといったパラメータをカード所有者が直接入力することは無く、
        //購買内容を元に加盟店様システムで生成した値が設定されるものと思います。
        $entryInput->setJobCd(JobCd::SAUTH);
        if (isset($orderId)) $entryInput->setOrderId( $orderId );
        if (isset($amount)) $entryInput->setAmount( $amount );
        //API通信クラスをインスタンス化します
        $exe = new EntryTran();

        //パラメータオブジェクトを引数に、実行メソッドを呼び、結果を受け取ります。
        return $exe->exec( $entryInput );
    }

    /**
     * @param EntryTranOutput $entryRes
     * @param string $orderId
     * @param string $token
     * @return ExecTranOutput|null
     * @throws \GMO\Commons\GPayException
     * @throws \ReflectionException
     */
    protected function payment(EntryTranOutput $entryRes, string $orderId, string $token) {
        //入力パラメータクラスをインスタンス化します
        $payInput = new ExecTranInput();

        //各種パラメータを設定します。
        //カード番号入力型・会員ID決済型に共通する値です。
        $payInput->setAccessId( $entryRes->getAccessId() );
        $payInput->setAccessPass( $entryRes->getAccessPass() );
        $payInput->setOrderId( $orderId );

        //支払方法を一括払いに設定
        $payInput->setMethod( 1 );
        // トークン決済の場合
        $payInput->setToken( $token );
        // カード情報トークン化サービス
        $payInput->setTokenType(1);

        //API通信クラスをインスタンス化します
        $exe = new ExecTran();

        //パラメータオブジェクトを引数に、実行メソッドを呼び、結果を受け取ります。
        return $exe->exec( $payInput );
    }
}
