<?php

namespace Paidy\Dto;

use Subscription\Dto\AbsDto;

/**
 * Paidyの注文についてのデータ
 * Class PaidyOrderDto
 */
class PaidyOrderDto extends AbsDto
{
    /**
     * この決済のすべての注文商品の配列
     * @var array[PaidyItemDto]
     */
    public $items;

    /**
     * 注文にかかる消費税
     * @var double
     */
    public $tax;

    /**
     * 注文にかかる配送料
     * @var double
     */
    public $shopping;

    /**
     * マーチャントが割り当てる注文IDまたはカートID
     * @var string
     */
    public $order_ref;
}
