<?php

namespace GMO\Trans;

use GMO\Commons\GPayException;
use GMO\Outputs\ExecTranOutput;

/**
 * <b>決済実行　実行クラス</b>
 *
 * @package com.gmo_pg.client
 * @subpackage tran
 * @see tranPackageInfo.php
 * @author GMO PaymentGateway
 * @version 1.0
 * @created 01-01-2008 00:00:00
 */
class ExecTran extends BaseTran {

    /**
     * 決済を実行する
     *
     * @param ExecTranInput $input 入力パラメータ
     * @return ExecTranOutput|null 出力パラメータ
     * @throws GPayException
     * @throws \ReflectionException
     */
	public function exec(&$input) {
        // プロトコル呼び出し・結果取得
        $resultMap = $this->callProtocol($input->toString());

        // 戻り値がnullの場合、nullを戻す
        if (is_null($resultMap)) {
		    return null;
        }

		// ExecTranOutputを作成し、戻す
		return new ExecTranOutput($resultMap);
	}

}