<?php

namespace Subscription\Providers;

use FileMaker\Configs\FmConfig;
use GMO\Configs\GmoConfig;
use Illuminate\Foundation\Application as LaravelApplication;
use Illuminate\Support\ServiceProvider;
use Paidy\Configs\PaidyConfig;

class WizSubscriptionServiceProvider extends ServiceProvider
{
    /**
     * GMOのクレカのToken取得URL：本番用
     */
    const GMO_TOKEN_PRO_JS_URL = 'https://static.mul-pay.jp/ext/js/token.js';

    /**
     * GMOのクレカのToken取得URL：テスト用
     */
    const GMO_TOKEN_DEV_JS_URL = 'https://stg.static.mul-pay.jp/ext/js/token.js';

    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        $configSource = realpath($raw = wiz_subs_base_path() . '/config/wiz_subscription.php') ?: $raw;
        if ($this->app instanceof LaravelApplication && $this->app->runningInConsole()) {
            $this->publishes([
                $configSource => config_path('wiz_subscription.php'),
            ]);
        }

        // GMO決済の設定
        $gmoSetting = config('wiz_subscription.gmo');
        if ($gmoSetting['is_used']) {
            GmoConfig::setSiteId($gmoSetting['site']['id']);
            GmoConfig::setSitePassword($gmoSetting['site']['password']);
            GmoConfig::setSiteName($gmoSetting['site']['name']);
            GmoConfig::setShopId($gmoSetting['shop']['id']);
            GmoConfig::setShopPassword($gmoSetting['shop']['password']);
            GmoConfig::setShopName($gmoSetting['shop']['name']);
            if ($gmoSetting['trial_mode']) {
                GmoConfig::setUrlInfoFilePath(wiz_subs_base_path() . '/config/gmo/connector.properties');
                GmoConfig::setTokenJsUrl(self::GMO_TOKEN_DEV_JS_URL);
            } else {
                GmoConfig::setUrlInfoFilePath(wiz_subs_base_path() . '/config/gmo/connector.properties.honban');
                GmoConfig::setTokenJsUrl(self::GMO_TOKEN_PRO_JS_URL);
            }
        }

        // Paidyの設定
        $paidySetting = config('wiz_subscription.paidy');
        if ($paidySetting['is_used']) {
            PaidyConfig::setIsTrial($paidySetting['trial_mode']);
            PaidyConfig::setPublicKey($paidySetting['public_key']);
            PaidyConfig::setSecurityKey($paidySetting['security_key']);
            PaidyConfig::setStoreName($paidySetting['store_name']);
        }
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}