<?php
return [
    // GMOの決済
    'gmo' => [
        // 使用可否：false - 使用しない、true - 使用する
        'is_used' => false,
        // テストモード：false - 本番、true - テスト
        'trial_mode' => env('GMO_TRIAL_MODE', false),
        'site' => [
            'id' => env('GMO_SITE_ID', 'サイトID'),
            'password' => env('GMO_SITE_PASSWORD', 'サイトパスワード'),
            'name' => env('GMO_SITE_NAME', 'サイト名'),
        ],
        // ショップ情報
        'shop' => [
            'id' => env('GMO_SHOP_ID', 'ショップID'),
            'password' => env('GMO_SHOP_PASSWORD', 'ショップパスワード'),
            'name' => env('GMO_SHOP_NAME', 'ショップ名'),
        ],
    ],
    // Paidyの決済
    'paidy' => [
        // 使用可否：false - 使用しない、true - 使用する
        'is_used' => false,
        // テストモード：false - 本番、true - テスト
        'trial_mode' => env('PAIDY_TRIAL_MODE', false),
        'public_key' => env('PAIDY_APP_KEY', ''),
        'security_key' => env('PAIDY_SECURITY_KEY', ''),
        'store_name' => env('PAIDY_STORE_NAME', ''),
    ],
    // FilemakerのAPI（参考用）：Singleton->Prototypeスコープに変更
    'fm' => [
        // 使用可否：false - 使用しない、true - 使用する
        'is_used' => false,
        'api_url' => '',
        'basic' => [
            'user_id' => '',
            'password' => '',
        ],
        'auth' => [
            'user_id' => '',
            'password' => '',
        ],
        'product_kbn' => '',
    ],
];