<?php
require_once (dirname(__FILE__).'/../common/Cryptgram.php');
require_once (dirname(__FILE__).'/../common/GPayException.php');
require_once (dirname(__FILE__).'/../output/DocomoIncreaseOutput.php');
require_once (dirname(__FILE__).'/../tran/BaseTran.php');
/**
 * <b>ドコモケータイ払い決済増額　実行クラス</b>
 *
 * @package com.gmo_pg.client
 * @subpackage tran
 * @see tranPackageInfo.php
 * @author GMO PaymentGateway
 * @version 1.0
 * @created 2016/10/11
 */
class DocomoIncrease extends BaseTran {

	/**
	 * コンストラクタ
	 */
	public function __construct() {
	    parent::__construct();
	}

	/**
	 * 決済増額を実行する
	 *
	 * @param  DocomoIncreaseInput $input  入力パラメータ
	 * @return DocomoIncreaseOutput $output 出力パラメータ
	 * @exception GPayException
	 */
	public function exec(&$input) {

        // 接続しプロトコル呼び出し・結果取得
        $resultMap = $this->callProtocol($input->toString());
	    // 戻り値がnullの場合、nullを戻す
        if (is_null($resultMap)) {
		    return null;
        }

        // DocomoIncreaseOutput作成し、戻す
	    return new DocomoIncreaseOutput($resultMap);
	}
}
?>
