<?php

namespace GMO\Services\CreditCard;

use GMO\Configs\GmoConfig;
use GMO\Inputs\SaveCardInput;
use GMO\Inputs\TradedCardInput;
use GMO\Outputs\SaveCardOutput;
use GMO\Outputs\TradedCardOutput;
use GMO\Trans\SaveCard;
use GMO\Trans\TradedCard;

/**
 * Class SimpleAuthorizationService
 * @package GMO\Services\CreditCard
 */
class CardService
{
    /**
     * 決済後カード登録
     *
     * @param $orderId
     * @param $memberId
     * @param null $holderName
     * @param int $defaultFlag 0:継続課金対象としない(デフォルト) 1:継続課金対象
     * @return TradedCardOutput
     * @throws \GMO\Commons\GPayException
     * @throws \ReflectionException
     */
    public function traded($orderId, $memberId, $holderName = null, $defaultFlag = 0)
    {
        // 決済後カード登録
        // 入力パラメータクラスをインスタンス化します
        $input = new TradedCardInput();

        //このサンプルでは、ショップID・サイトID・パスワードはコンフィグファイルで
        //定数defineしています。
        $input->setShopId( GmoConfig::getShopId() );
        $input->setShopPass( GmoConfig::getShopPassword() );
        $input->setSiteId( GmoConfig::getSiteId() );
        $input->setSitePass( GmoConfig::getSitePassword() );

        // 登録したい取引と、会員IDを指定します。
        $input->setMemberId( $memberId );
        $input->setOrderId( $orderId );
        if (isset($holderName)) $input->setHolderName($holderName);
        $input->setDefaultFlag($defaultFlag);

        // API通信クラスをインスタンス化します
        $exe = new TradedCard();

        // パラメータオブジェクトを引数に、実行メソッドを呼びます。
        // 正常に終了した場合、結果オブジェクトが返るはずです。
        return $exe->exec( $input );
    }

    /**
     * 登録
     *
     * @param $memberId
     * @param $token
     * @param int $defaultFlag 0:継続課金対象としない(デフォルト) 1:継続課金対象
     * @return SaveCardOutput
     * @throws \GMO\Commons\GPayException
     * @throws \ReflectionException
     */
    public function save($memberId, $token, $defaultFlag = 0) {
        // 会員登録の処理
        // 入力パラメータクラスをインスタンス化します
        $input = new SaveCardInput();

        // サイトID・パスワードはコンフィグファイルで
        $input->setSiteId( GmoConfig::getSiteId() );
        $input->setSitePass( GmoConfig::getSitePassword() );

        //会員IDは必須です
        $input->setMemberId( $memberId );

        // トークンでカード番号を設定します。
        $input->setToken( $token);

        $input->setDefaultFlag( $defaultFlag );

        //API通信クラスをインスタンス化します
        $exe = new SaveCard();

        //パラメータオブジェクトを引数に、実行メソッドを呼びます。
        //正常に終了した場合、結果オブジェクトが返るはずです。
        return $exe->exec( $input );
    }
}
