<?php
require_once (dirname(__FILE__).'/../output/BaseOutput.php');
/**
 * <b>多通貨クレジット決済（DCC)全レート照会　出力パラメータクラス</b>
 *
 * @package com.gmo_pg.client
 * @subpackage output
 * @see outputPackageInfo.php
 * @author GMO PaymentGateway
 */
class SearchRateAllDccOutput extends BaseOutput {

	/**
	 * @var string レート情報
	 */
	private $rateData;


	/**
	 * コンストラクタ
	 *
	 * @param IgnoreCaseMap $params  出力パラメータ
	 */
	public function __construct($params = null) {
		parent::__construct($params);

		// 引数が無い場合は戻る
		if (is_null($params)) {
            return;
        }

        // マップの展開
		$this->setRateData($params->get('RateData'));

	}

	/**
	 * レート情報取得
	 * @return string レート情報
	 */
	public function getRateData() {
		return $this->rateData;
	}

	/**
	 * レート情報設定
	 *
	 * @param string $rateData
	 */
	public function setRateData($rateData) {
		$this->rateData = $rateData;
	}

	/**
	 * 文字列表現
	 * <p>
	 *  現在の各パラメータを、パラメータ名=値&パラメータ名=値の形式で取得します。
	 * </p>
	 * @return string 出力パラメータの文字列表現
	 */
	public function toString() {
		$str ='';
		$str .= 'RateData=' . $this->encodeStr($this->getRateData());


	    if ($this->isErrorOccurred()) {
            // エラー文字列を連結して返す
            $errString = parent::toString();
            $str .= '&' . $errString;
        }

        return $str;
	}

}
?>
