<?php

namespace GMO\Configs;



/**
 * GMOの決済環境
 *
 * Class GmoConfig
 * @package GMO\Configs
 */
class GmoConfig
{
    /**
     * インスタンス
     * @var GmoConfig
     */
    private static $instance;

    /**
     * サイトID
     * @var string
     */
    private $siteId;

    /**
     * サイトパスワード
     * @var string
     */
    private $sitePassword;

    /**
     * サイト名
     * @var string
     */
    private $siteName;

    /**
     * ショップID
     * @var string
     */
    private $shopId;

    /**
     * ショップパスワード
     * @var string
     */
    private $shopPassword;

    /**
     * ショップ名
     * @var string
     */
    private $shopName;

    /**
     * URL情報のパス
     * @var string
     */
    private $urlInfoFilePath;

    /**
     * Token取得用のJSのURL
     * @var string
     */
    private $tokenJsUrl;

    /**
     * GmoConfig constructor.
     */
    private function __construct()
    {
    }

    /**
     * サイトIDを取得
     * @return string
     */
    public static function getSiteId(): string
    {
        $self = self::$instance;
        if (is_null($self)) {
            throw new \RuntimeException\RuntimeException('Not set configuration!!');
        }
        return $self->siteId;
    }

    /**
     * サイトIDを設定
     * @param string $siteId
     */
    public static function setSiteId(string $siteId)
    {
        $self = self::getInstance();
        $self->siteId = $siteId;
    }

    /**
     * サイトパスワードを取得
     * @return string
     */
    public static function getSitePassword()
    {
        $self = self::$instance;
        if (is_null($self)) {
            throw new \RuntimeException\RuntimeException('Not set configuration!!');
        }
        return $self->sitePassword;
    }

    /**
     * サイトパスワードを設定
     * @param string $sitePassword
     */
    public static function setSitePassword(string $sitePassword)
    {
        $self = self::getInstance();
        $self->sitePassword = $sitePassword;
    }

    /**
     * サイト名を取得
     * @return string
     */
    public static function getSiteName()
    {
        $self = self::$instance;
        if (is_null($self)) {
            throw new \RuntimeException\RuntimeException('Not set configuration!!');
        }
        return $self->siteName;
    }

    /**
     * サイト名を設定
     * @param string $siteName
     */
    public static function setSiteName(string $siteName)
    {
        $self = self::getInstance();
        $self->siteName = $siteName;
    }

    /**
     * ショップIDを設定
     *
     * @param string $shopId
     */
    public static function setShopId($shopId) {
        $self = self::getInstance();
        $self->shopId = $shopId;
    }

    /**
     * ショップIDを取得
     *
     * @return string
     */
    public static function getShopId() {
        $self = self::$instance;
        if (is_null($self)) {
            throw new \RuntimeException\RuntimeException('Not set configuration!!');
        }
        return $self->shopId;
    }

    /**
     * ショップパスワードを設定
     *
     * @param string $shopPassword
     */
    public static function setShopPassword($shopPassword) {
        $self = self::getInstance();
        $self->shopPassword = $shopPassword;
    }

    /**
     * ショップパスワードを取得
     *
     * @return string
     */
    public static function getShopPassword() {
        $self = self::$instance;
        if (is_null($self)) {
            throw new \RuntimeException('Not set configuration!!');
        }
        return $self->shopPassword;
    }

    /**
     * ショップ名を設定
     *
     * @param string $shopName
     */
    public static function setShopName($shopName) {
        $self = self::getInstance();
        $self->shopName = $shopName;
    }

    /**
     * ショップ名を取得
     *
     * @return string
     */
    public static function getShopName() {
        $self = self::$instance;
        if (is_null($self)) {
            throw new \RuntimeException('Not set configuration!!');
        }
        return $self->shopName;
    }

    /**
     * URL情報のパスを設定
     *
     * @param $urlInfoFilePath
     * @return string
     */
    public static function setUrlInfoFilePath($urlInfoFilePath) {
        $self = self::getInstance();
        $self->urlInfoFilePath = $urlInfoFilePath;
    }

    /**
     * URL情報のパスを設定
     *
     * @return string
     */
    public static function getUrlInfoFilePath() {
        $self = self::$instance;
        if (is_null($self)) {
            throw new \RuntimeException('Not set configuration!!');
        }
        return $self->urlInfoFilePath;
    }

    /**
     * Token取得用のJSのURLを設定
     *
     * @param string $tokenJsUrl
     * @return mixed
     */
    public static function setTokenJsUrl($tokenJsUrl) {
        $self = self::getInstance();
        $self->tokenJsUrl = $tokenJsUrl;
    }

    /**
     * Token取得用のJSのURLを取得
     *
     * @return string
     */
    public static function getTokenJsUrl() {
        $self = self::$instance;
        if (is_null($self)) {
            throw new \RuntimeException('Not set configuration!!');
        }
        return $self->tokenJsUrl;
    }

    /**
     * インスタンスを作成・取得
     *
     * @return GmoConfig
     */
    public static function getInstance() {
        if (is_null(self::$instance)) {
            self::$instance = new GmoConfig();
        }

        return self::$instance;
    }
}