<?php

namespace Subscription\Traits;

/**
 * Trait Object2Array
 * @package Subscription\Traits
 */
trait Object2Array
{
    /**
     * 連想配列に変換
     * @return array
     */
    public function toArray()
    {
        $properties = (array) $this;
        return $this->toArrayRecursive($properties);
    }

    /**
     * @param $property
     * @return array
     */
    private function toArrayRecursive($property)
    {
        $array = [];
        foreach ($property as $key => $value) {
            if (is_array($value)) {
                $array[$key] = $this->toArrayRecursive($value);;
            } else if (is_object($value)) {
                $child = (array) $value;
                $array[$key] = $this->toArrayRecursive($child);;
            } else {
                $array[$key] = $value;
            }
        }
        return $array;
    }
}
