# Wiz Subscription

本モジュールはGMO決済、Paidy決済、FilemakerのAPI連携の機能を含まれています。

### G. GMOトークン決済

![トークン決済](https://www.gmo-pg.com/service/mulpay/security/token/img/flow_token.png "トークン決済")

画像の「加盟店様サイト」というのが実装予定のサービスです。

* 1:購入画面からの表示
* 2:htmlからJavaScriptへリンクし、カード番号送信
* 3:トークン返却
* 4:トークン送信
* 5:トークン＋金額でオーソリ処理
* 6:トークンをカード番号に置き換えてオーソリ処理
* 7:オーソリ結果返却
* 8:オーソリ結果返却
* 9:レシートページ表示

**カード情報をG.4番の処理でサーバーサイドでGMOのAPIを利用して注文情報と一緒にGMOへ送る方法もありますが、今回の決済方法をトークン決済にした理由として加盟店様サイトが別途カード会社（VISA等）の承認をもらう必要があり、ワイズはその承認をもらってないからです。**



テストのためにGMOのテストアカウントの申請が必要（PMかディレクター）で、その時以下の内容を頂く必要がある。

* サイトID
* サイトパスワード
* ショップID
* ショップパスワード 
* テスト用のGMO管理画面のログイン情報

**本番の設定の為に別途「サイトID」、「サイトパスワード」、「ショップID」、「ショップパスワード」のが必要。**

参考：https://www.gmo-pg.com/service/mulpay/security/token/

### P. Paidy決済

![トークン決済](https://paidy.com/docs/images/tok_payments_flow_jp.png "トークン決済")

画像の「マーチャント」というのが実装予定のサービスです。

* 1:Paidyで提供されたJSでモーダルで表示される
* 2:モーダル内で行うPaidy側とコンシューマーとの認証
* 3:2のモーダルからTokenを頂いて注文情報と一緒に構築サービスでPaidyのAPIを実行して決済を行う

P.1の処理する前にコンシューマーはPaidyの会員登録されている状態にしないといけないです。



事前にPaidyの法人用のアカウントが必要で管理画面にで以下の内容を頂く必要がある。
![Paidy管理画面](https://pitchplus.zendesk.com/hc/article_attachments/360050531913/paidy01.jpg "Paidy管理画面")

* パブリックキー
* シークレットキー

**Paidyの場合、テスト用のキーが同時に発行されるので、管理アカウントは一個でOk**

参考：https://paidy.com/docs/jp/payments.html#create_subs

## 1. 使用環境
* php : 7.0以上

## 2. インストール
composerを利用してインストールするための設定を行います。
auth.jsonをcomoesr.jsonと同じところに作成します。
```javascript
{
    "bitbucket-oauth": {
        "bitbucket.org": {
            "consumer-key": "xXvgwJ6veb95Sxf6c8",
            "consumer-secret": "y95gPztjXwjcahmmjuKTgkZd5spGEcrE"
        }
    }
}
```
composer.jsonに以下を追記します。
```javascript
    ...
    "repositories": [
        {
            "type": "git",
            "url": "https://bitbucket.org/w012/wiz-subscription.git"
        }
    ],
    ...
```
パッケージをインストールします。
```bash
$ composer require fatty-rabbit/wiz-subscription:dev-master
```

## 3. 環境設定
### A. Laravel
#### Providerの登録
5.5の前バージョンのみconfig/app.phpに以下を登録します。

```php
'providers' => [
    ...
    Subscription\Providers\WizSubscriptionServiceProvider::class,
],
```

#### 環境ファイルの発行
以下のコンマンドでconfig/wiz_subscription.phpファイルを発行します。
```bash
$ php artisan vendor:publish --provider="Subscription\Providers\WizSubscriptionServiceProvider"
``` 

#### 環境ファイルの修正
config/wiz_subscription.phpファイルを修正します。
```php
<?php
return [
    // GMOの決済
    'gmo' => [
        // 使用可否：false - 使用しない、true - 使用する
        'is_used' => false,
        // テストモード：false - 本番、true - テスト
        'trial_mode' => env('GMO_TRIAL_MODE', false),
        'site' => [
            'id' => env('GMO_SITE_ID', 'サイトID'),
            'password' => env('GMO_SITE_PASSWORD', 'サイトパスワード'),
            'name' => env('GMO_SITE_NAME', 'サイト名'),
        ],
        // ショップ情報
        'shop' => [
            'id' => env('GMO_SHOP_ID', 'ショップID'),
            'password' => env('GMO_SHOP_PASSWORD', 'ショップパスワード'),
            'name' => env('GMO_SHOP_NAME', 'ショップ名'),
        ],
    ],
    // Paidyの決済
    'paidy' => [
        // 使用可否：false - 使用しない、true - 使用する
        'is_used' => false,
        // テストモード：false - 本番、true - テスト
        'trial_mode' => env('PAIDY_TRIAL_MODE', false),
        'public_key' => env('PAIDY_APP_KEY', 'パブリックキー'),
        'security_key' => env('PAIDY_SECURITY_KEY', 'シークレットキー'),
        'store_name' => env('PAIDY_STORE_NAME', 'ショップ名'),
    ],
    // FilemakerのAPI
    'fm' => [
        // 使用可否：false - 使用しない、true - 使用する
        'is_used' => false,
        'api_url' => 'APIのURL',
        'basic' => [
            'user_id' => 'Basic認証のID',
            'password' => 'Basic認証のパスワード',
        ],
        'auth' => [
            'user_id' => 'ログインID',
            'password' => 'ログインパスワード',
        ],
        'product_kbn' => '商材区分',
    ],
];
```
上記の設定の値はPMまたはディレクターから頂く

### B. 一般：Laravel以外
#### GMOの決済
GMO決済のために環境クラスを設定しておきます。
```php
GmoConfig::setSiteId('サイトID');
GmoConfig::setSitePassword('サイトパスワード');
GmoConfig::setSiteName('サイト名');
GmoConfig::setShopId('ショップID');
GmoConfig::setShopPassword('ショップパスワード');
GmoConfig::setShopName('ショップ名');
// テストの時
GmoConfig::setUrlInfoFilePath(wiz_subs_base_path() . '/config/gmo/connector.properties');
GmoConfig::setTokenJsUrl('https://stg.static.mul-pay.jp/ext/js/token.js');
/* 本番の時
GmoConfig::setUrlInfoFilePath(wiz_subs_base_path() . '/config/gmo/connector.properties.honban');
GmoConfig::setTokenJsUrl('https://static.mul-pay.jp/ext/js/token.js');
*/
```

#### Paidyの決済
Paidy決済のために環境クラスを設定しておきます。
```php
PaidyConfig::setIsTrial('テストの可否');
PaidyConfig::setPublicKey('パブリックキー');
PaidyConfig::setSecurityKey('シークレットキー');
PaidyConfig::setStoreName('ショップ名');
```

## 4. 実装

### A. GMOの決済
#### Javascriptの連携（Token作成）
JSでカード情報をGMOに送り、Tokenを取得します。この実装はオーソリではなく、**GMOのAPIが実行される際にカードのオーソリが行います。**
```php
<?php include_gmo_js() ?>
var completeCardAuth  = function(token) {
    if (token === false) {
        // 失敗の場合
    } else {
        // 成功した場合
        console.log(token);
    }
}
...
var gmoTokenGetter = new GmoCardTokenGetter({
    cardNo: 'カード番号',
    expire: '有効期限',
    securityCode: 'セキュリティーコード',
    callBack: completeCardAuth
});
gmoTokenGetter.execute();
```
以下の項目は入力画面から取得した物

* カード番号：**テストする時は「4111111111111111」テスト可能**
* 有効期限:YYMM 形式
* セキュリティーコード

詳しいテスト環境専用カード番号
* [正常クレジットカード](https://faq.gmo-pg.com/service/Detail.aspx?id=e5073474546666b675a6c315734355167517034383975512b734a382b594b2f4a72767350474575344c56493d) 
* [エラー確認用クレジットカード](https://faq.gmo-pg.com/service/Detail.aspx?id=e5073474546666b675a6c315734355167517034383967795943655930713778637331655a654141436a6c4d3d) 

#### 注文後のカード登録する場合
##### APIによるオーソリの実行
```php
// オーソリ
$gmoService = new \GMO\Services\CreditCard\SimpleAuthorizationService();
$cardAuthRes = $gmoService->auth('注文ID', 'Token', '金額');
if ($cardAuthRes->isErrorOccurred()) {
    // 決済処理が失敗の場合
    print_r($cardAuthRes->getErrList());
}
```

* 注文ID：構築サービス側で上記「G.4」の処理で作成した注文を区別するID
* Toke：上記「G.3」の処理で実装の「completeCardAuth」でGMOから取得したToken
* 金額：構築サービス側で上記「G.4」の処理で作成したか画面から入力された金額、決済を行う金額

#### APIによるカードの登録
カードの登録が必要な場合（決済チームの仕様の共有がよくないので、今後変更の可能性がある）
```php
// 会員登録
$memberService = new \GMO\Services\Member\MemberService();
$memberResult = $memberService->save('会員ID', '会員名');
print_r($memberResult, true);

// カードの登録
$cardService = new \GMO\Services\CreditCard\CardService();
$cardResult = $cardService->traded('注文ID', '会員ID', 'カード名義', カードのデフォルト);
print_r($cardResult, true);
```

* 注文ID：構築サービス側で上記「G.4」の処理で作成した注文を区別するID
* 会員ID：構築サービス側で上記「G.4」の処理で作成した会員を区分するID（会員管理をしない場合注文IDを利用する）
* 会員名：構築サービス側で上記「G.4」の処理で作成した会員名
* カード名義人：Token形式ででカードカード情報が紐つく仕様ですが、実際は別途「カード名義人」入れない（default：null）
* カードのデフォルト: 1->default、0->defaultではない（一人の会員へ複数のカードを設定する場合優先で使用するカード）

サービスのレスは基本的にGMOの物をそのまま利用しております。

#### カード登録のみの場合
##### APIによるカードの登録
事前に会員にカードを登録する場合使用します。
```php
// 会員登録（登録が必要な場合）
$memberService = new \GMO\Services\Member\MemberService();
$memberResult = $memberService->save('会員ID', '会員名');
print_r($memberResult, true);

// カードの登録
$cardService = new \GMO\Services\CreditCard\CardService();
$cardResult = $cardService->save('会員ID', 'Token', カードのデフォルト);
if ($cardResult->isErrorOccurred()) {
    // 決済処理が失敗の場合
    print_r($cardResult->getErrList());
}
```

* 会員ID：構築サービス側で上記「G.4」の処理で作成した会員を区分するID（会員管理をしない場合注文IDを利用する）
* 会員名：構築サービス側で上記「G.4」の処理で作成した会員名
* Toke：上記「G.3」の処理で実装の「completeCardAuth」でGMOから取得したToken
* カードのデフォルト: 1->default、0->defaultではない（一人の会員へ複数のカードを設定する場合優先で使用するカード）

サービスのレスは基本的にGMOの物をそのまま利用しております。

##### エラーの時、実装結果の形式&取得方法
```
[errList:GMO\Outputs\BaseOutput:private] => Array
(
    [0] => GMO\Outputs\ErrHolder Object
        (
            [errCode:GMO\Outputs\ErrHolder:private] => G12
            [errInfo:GMO\Outputs\ErrHolder:private] => 42G120000
            [errMsg:GMO\Outputs\ErrHolder:private] => このカードでは取引をする事が出来ません。
        )
    [1] => GMO\Outputs\ErrHolder Object .....
)

$errArr = $cardResult->getErrList();
echo $errArr[0]->getErrCode();
echo $errArr[0]->getErrInfo();
echo $errArr[0]->getErrMsg();
```

### B. Paidyの決済
#### Javascriptの連携
JSでPaidyのTokenを取得します。

```php
<?php include_paidy_js() ?>
var payload = function(tokenId) {
    console.log(tokenId);
};

var paidyPay = function() {
    var paidyCheckouter = new PaidyCheckouter({
        firstName: '名',
        lastName: '姓',
        firstKana: '名かな',
        lastKana: '姓かな',
        email: 'メールアドレス',
        phone: '電話番号',
        callBack: payload
    });
    paidyCheckouter.execute();
}
```

* 名:構築サービス側で上記「P.1」を呼び出す際に作成したか画面から入力された値
* 姓:構築サービス側で上記「P.1」を呼び出す際に作成したか画面から入力された値
* 名かな:構築サービス側で上記「P.1」を呼び出す際に作成したか画面から入力された値
* 姓かな:構築サービス側で上記「P.1」を呼び出す際に作成したか画面から入力された値
* メールアドレス:構築サービス側で上記「P.1」を呼び出す際に作成したか画面から入力された値（**テスト用の場合、「successful.payment@paidy.com」**）
* 電話番号:構築サービス側で上記「P.1」を呼び出す際に作成したか画面から入力された値（**テスト用の場合、「08000000001」**）
* **テスト用の場合、「P.1」のモーダルで認証コードは「8888」を使用**

#### APIによる決済の実行
PaidyのAPIを利用して決済を行います。**説明はコメントアウトを参考**
```php
// Paidyの決済DTO
$paymentDto = new \Paidy\Dto\PaidyPaymentDto();
// Paidyのモーダルで取得したTOKEN
// Paidyが生成する、「tok_」で始まるトークンID
$paymentDto->token_id = ''; 
// 画面及構築サービス側で取得した金額
// 税、送料を含む決済総額
$paymentDto->amount = 1000; 
// 通貨
// 固定で良い
$paymentDto->currency = 'JPY';

// コンシューマーの購入履歴に関する情報
$buyerDto = new \Paidy\Dto\PaidyBuyerDataDto();
// コンシューマーが店舗でアカウントを作成してから経過した日数
// ユーザー管理がないシステムでは任意の1
$buyerDto->age = 1; 
// コンシューマーが取引を開始してから現在までに行った注文総数
// ユーザー管理がないシステムでは任意の1
$buyerDto->order_count = 1; 
// コンシューマーが取引を開始してから現在までに行った注文の総額（円）
// ユーザー管理がないシステムでは任意
$buyerDto->ltv = 10000;
// 最後に行った注文の金額（円）
// ユーザー管理がないシステムでは任意
$buyerDto->last_order_amount = 10000;
// コンシューマーが最後に注文してから経過した日数
// ユーザー管理がないシステムでは任意
$buyerDto->last_order_at = 22;
$paymentDto->buyer_data = $buyerDto;

// Paidyの決済のすべての注文商品
$itemDto = new \Paidy\Dto\PaidyItemDto();
// 注文商品の数
// 割引や送料、税金など計算して合わないと行けないので正確に計算できない場合はサービスの注文として1で設定
$itemDto->quantity = 1;
// 注文商品の単価
$itemDto->unit_price = 1000;

// Paidyの注文についてのデータ
$orderDto = new \Paidy\Dto\PaidyOrderDto();
$orderDto->items = [$itemDto];
// マーチャントが割り当てる注文IDまたはカートID
$orderDto->order_ref = 'AB000000000001';
$paymentDto->order = $orderDto;

// コンシューマーの配送先
$shippingAddressDto = new \Paidy\Dto\PaidyShippingAddressDto();
// 画面及構築サービス側で取得した配達先の都道府県
$shippingAddressDto->state = '東京都';
// 画面及構築サービス側で取得した配達先の郵便番号（NNN-NNNN形式）
$shippingAddressDto->zip = '170-0005';
$paymentDto->shipping_address = $shippingAddressDto;

$paymentRes = \Paidy\Services\PaidyApiService::pay($paymentDto);
```
このサンプルは必須のみの設定で他の項目の利用が必要な場合は以下のURLを参考してください。
https://paidy.com/docs/api/jp/index.html#2-2-

### C. FileMakerのAPI連携
FileMaker\Services\Post2FmServiceを継承して使用します。
```php
class SampleService extends FileMaker\Services\Post2FmService {

    /**
     * @inheritDoc
     */
    protected function convertForFm(array $original) {

        $fmInputData = array();
        // データーの入れ替え
        ...

        return $fmInputData;
    }

    /**
     * @inheritDoc
     */
    protected function getYmdFields()
    {
        return [];
    }

    /**
     * @inheritDoc
     */
    protected function getRequireFields()
    {
        return [];
    }
}
```

* convertForFm：入力値を利用してFileMaker用のデーターを作成
* getYmdFields：日付項目（2020年05月03日→2020/05/03に変換する）
* getRequireFields：必須項目

実際使用例
```php
$fmConfig = new FmConfig();
$fmConfig->setApiUrl('APIのURL');
$fmConfig->setBasicUserId('Basic認証のID');
$fmConfig->setBasicPassword('Basic認証のパスワード');
$fmConfig->setAuthUserId('ログインID');
$fmConfig->setAuthPassword('ログインパスワード');
$fmConfig->setProductKbn('商材区分');

// Laravelの場合は設定ファイルから作成
$fmConfig = FmConfig::getInstance(confi('wiz_subscription.fm'));

$service = new Post2FmService($fmConfig);
$service->sendApi($inputOriginalData);

if ($service === false) {
    // APIの失敗の場合
    ...
}
```