<?php

namespace Paidy\Dto;

use Subscription\Dto\AbsDto;
use Subscription\Traits\Object2Array;

/**
 * Paidyの決済DTO
 * Class PaidyPaymentDto
 */
class PaidyPaymentDto extends AbsDto
{
    use Object2Array;

    /**
     * TokenのID
     * @var string
     */
    public $token_id;

    /**
     * 税、送料を含む決済総額
     * @var double
     */
    public $amount;

    /**
     * 決済で使用する通貨
     * @var string
     */
    public $currency;

    /**
     * 決済についての説明
     * @var string
     */
    public $description;

    /**
     * マーチャントの店舗名(MyPaidyとマーチャントダッシュボードに表示される)
     * @var string
     */
    public $store_name;

    /**
     * コンシューマーの購入履歴に関する情報
     * @var PaidyBuyerDataDto
     */
    public $buyer_data;

    /**
     * 注文についてのデータ
     * @var PaidyOrderDto
     */
    public $order;

    /**
     * マーチャントが定義する、オブジェクトについてのデータ
     * @var string
     */
    public $metadata;

    /**
     * コンシューマーの配送先
     * @var PaidyShippingAddressDto
     */
    public $shipping_address;
}
