<?php
require_once (dirname(__FILE__).'/../common/Cryptgram.php');
require_once (dirname(__FILE__).'/../common/GPayException.php');
require_once (dirname(__FILE__).'/../output/DocomoContinuanceShopEndOutput.php');
require_once (dirname(__FILE__).'/../tran/BaseTran.php');
/**
 * <b>ドコモ継続決済　継続課金終了(加盟店)　実行クラス</b>
 *
 * @package com.gmo_pg.client
 * @subpackage tran
 * @see tranPackageInfo.php
 * @author GMO PaymentGateway
 * @version 1.0
 * @created 2012/08/21
 */
class DocomoContinuanceShopEnd extends BaseTran {

	/**
	 * コンストラクタ
	 */
	public function __construct() {
	    parent::__construct();
	}

	/**
	 * 決済実行を実行する
	 *
	 * @param  DocomoContinuanceShopEndInput $input  入力パラメータ
	 * @return DocomoContinuanceShopEndOutput $output 出力パラメータ
	 * @exception GPayException
	 */
	public function exec(&$input) {

        // 接続しプロトコル呼び出し・結果取得
        $resultMap = $this->callProtocol($input->toString());
	    // 戻り値がnullの場合、nullを戻す
        if (is_null($resultMap)) {
		    return null;
        }

        // DocomoContinuanceShopEndOutput作成し、戻す
	    return new DocomoContinuanceShopEndOutput($resultMap);
	}
}
?>
