<?php

namespace GMO\Services\Member;

use GMO\Configs\GmoConfig;
use GMO\Inputs\SaveMemberInput;
use GMO\Outputs\SaveMemberOutput;
use GMO\Trans\SaveMember;

/**
 * Class SimpleAuthorizationService
 * @package GMO\Services\CreditCard
 */
class MemberService
{
    /**
     * 登録
     *
     * @param string $memberId
     * @param string $memberName
     * @param string $nameCharset
     * @return SaveMemberOutput
     * @throws \GMO\Commons\GPayException
     * @throws \ReflectionException
     */
    public function save($memberId, $memberName = null, $nameCharset = 'UTF-8') {
        // 会員登録の処理
        // 入力パラメータクラスをインスタンス化します
        $input = new SaveMemberInput();

        // サイトID・パスワードはコンフィグファイル
        $input->setSiteId( GmoConfig::getSiteId() );
        $input->setSitePass( GmoConfig::getSitePassword() );

        //会員IDは必須です
        $input->setMemberId( $memberId );

        //会員名称は任意です。
        if (!is_null($memberName)) {
            //会員名称は任意です。
            $input->setMemberName( mb_convert_encoding( $memberName , 'SJIS' , $nameCharset ) );
        }

        //API通信クラスをインスタンス化します
        $exe = new SaveMember();

        //パラメータオブジェクトを引数に、実行メソッドを呼びます。
        //正常に終了した場合、結果オブジェクトが返るはずです。
        return $exe->exec( $input );
    }
}
