<?php

namespace FileMaker\Configs;


/**
 * FileMakerの環境
 *
 * Class FmConfig
 * @package FileMaker\Configs
 */
class FmConfig
{
    /**
     * インスタンス
     * @var FmConfig
     */
    private static $instance;

    /**
     * APIのURL
     * @var
     */
    private $apiUrl;

    /**
     * Basic認証のID
     * @var
     */
    private $basicUserId;

    /**
     * Basic認証のパスワード
     * @var
     */
    private $basicPassword;

    /**
     * ログインID
     * @var
     */
    private $authUserId;

    /**
     * ログインパスワード
     * @var
     */
    private $authPassword;

    /**
     * 商材区分
     * @var
     */
    private $productKbn;

    /**
     * FmConfig constructor.
     */
    private function __construct()
    {
    }

    /**
     * @return mixed
     */
    public static function getApiUrl()
    {
        $self = self::$instance;
        if (is_null($self)) {
            throw new \RuntimeException('Not set configuration!!');
        }
        return $self->apiUrl;
    }

    /**
     * @param mixed $apiUrl
     */
    public static function setApiUrl($apiUrl)
    {
        $self = self::getInstance();
        $self->apiUrl = $apiUrl;
    }

    /**
     * @return mixed
     */
    public static function getBasicUserId()
    {
        $self = self::$instance;
        if (is_null($self)) {
            throw new \RuntimeException('Not set configuration!!');
        }
        return $self->basicUserId;
    }

    /**
     * @param mixed $basicUserId
     */
    public static function setBasicUserId($basicUserId)
    {
        $self = self::getInstance();
        $self->basicUserId = $basicUserId;
    }

    /**
     * @return mixed
     */
    public static function getBasicPassword()
    {
        $self = self::$instance;
        if (is_null($self)) {
            throw new \RuntimeException('Not set configuration!!');
        }
        return $self->basicPassword;
    }

    /**
     * @param mixed $basicPassword
     */
    public static function setBasicPassword($basicPassword)
    {
        $self = self::getInstance();
        $self->basicPassword = $basicPassword;
    }

    /**
     * @return mixed
     */
    public static function getAuthUserId()
    {
        $self = self::$instance;
        if (is_null($self)) {
            throw new \RuntimeException('Not set configuration!!');
        }
        return $self->authUserId;
    }

    /**
     * @param mixed $authUserId
     */
    public static function setAuthUserId($authUserId)
    {
        $self = self::getInstance();
        $self->authUserId = $authUserId;
    }

    /**
     * @return mixed
     */
    public static function getAuthPassword()
    {
        $self = self::$instance;
        if (is_null($self)) {
            throw new \RuntimeException('Not set configuration!!');
        }
        return $self->authPassword;
    }

    /**
     * @param mixed $authPassword
     */
    public static function setAuthPassword($authPassword)
    {
        $self = self::getInstance();
        $self->authPassword = $authPassword;
    }

    /**
     * @return mixed
     */
    public static function getProductKbn()
    {
        $self = self::$instance;
        if (is_null($self)) {
            throw new \RuntimeException('Not set configuration!!');
        }
        return $self->productKbn;
    }

    /**
     * @param mixed $productKbn
     */
    public static function setProductKbn($productKbn)
    {
        $self = self::getInstance();
        $self->productKbn = $productKbn;
    }

    /**
     * インスタンスを作成・取得
     *
     * @return FmConfig
     */
    public static function getInstance() {
        if (is_null(self::$instance)) {
            self::$instance = new FmConfig();
        }

        return self::$instance;
    }
}