
<script src="https://apps.paidy.com/"></script>
<script>
    var PaidyCheckouter = (function() {
        var PaidyCheckouter = function(args) {
            if(!(this instanceof PaidyCheckouter)) {
                return new PaidyCheckouter(args);
            }
            this.paidyHandler = Paidy.configure({
               "api_key": "<?php echo paidy_public_key(); ?>",
               "logo_url": args.hasOwnProperty('logoUrl') ? args.logoUrl : '',
               "token": {
                   "wallet_id": "default",
                       "type": "recurring",
               },
               "closed": function(callbackData) {
                   if (args.hasOwnProperty('callBack')) {
                       args.callBack(callbackData.id);
                   }
               }
            });
            this.shopName = "<?php echo paidy_store_name() ?>";
            this.firstName = args.firstName;
            this.lastName = args.lastName;
            this.firstKana = args.firstKana;
            this.lastKana = args.lastKana;
            <?php if(paidy_is_trial()) { ?>

            this.email = "successful.payment@paidy.com";
            this.phone = "08000000001";
            <?php } else { ?>

            this.email = args.email;
            this.phone = args.phone;
            <?php } ?>
        }

        var p = PaidyCheckouter.prototype;

        p.execute = function() {
            this.paidyHandler.launch({
                "store_name": this.shopName,
                "buyer": {
                    "email": this.email,
                    "name1": this.lastName + "　" + this.firstName,
                    "name2": this.lastKana + "　" + this.firstKana,
                    "phone": this.phone
                }
            });
        }

        return PaidyCheckouter;
    })();
</script>